const LoginHistory = require("../models/loginHistoryModel");
const UAParser = require("ua-parser-js");
const fetch = require("node-fetch"); // or global fetch if using Node 18+

exports.recordLogin = async (
  user,
  req,
  status = "success",
  method = "password"
) => {
  try {
    const userAgent = req.headers["user-agent"];
    const parser = new UAParser(userAgent);
    const parsed = parser.getResult();

    // Parse Device Info
    const os = parsed.os.name || "Unknown OS";
    const osVersion = parsed.os.version || "";
    const browser = parsed.browser.name || "Unknown Browser";
    const browserVersion = parsed.browser.version || "";
    const device = `${os} ${osVersion} · ${browser} ${browserVersion}`;

    // Extract IP (trust proxy if behind one)
    const ip =
      req.headers["x-forwarded-for"]?.split(",")[0] ||
      req.connection.remoteAddress;

    // Get Location from IP
    let location = "Unknown Location";
    try {
      const geoRes = await fetch(`http://ip-api.com/json/${ip}`);
      const geoData = await geoRes.json();
      if (geoData.status === "success") {
        // location = `${geoData.city}, ${geoData.regionName}, ${geoData.country}`;
        location = `${geoData.country}`;
      }
    } catch (geoErr) {
      console.warn("⚠️ Failed to fetch geolocation:", geoErr.message);
    }

    // Save to DB
    const loginRecord = new LoginHistory({
      user: user._id,
      device,
      ip,
      location,
      status,
      method,
    });

    await loginRecord.save();
    return loginRecord;
  } catch (error) {
    console.error("Error recording login:", error);
    throw error;
  }
};

// Get user's login history
exports.getLoginHistory = async (req, res) => {
  try {
    const history = await LoginHistory.find({ user: req.user.id }).sort({
      createdAt: -1,
    });

    const total = await LoginHistory.countDocuments({ user: req.user.id });
    res.status(200).send(history);
  } catch (error) {
    console.error("Error fetching login history:", error);
    throw error;
  }
};
