const Outofstocklimit = require("../models/outofstocklimitModel");
const Outofstockintervals = require("../models/outofstockIntervalsModel");
const DebtorsHistory = require("../models/debtorsHistoryModel");
const Category = require("../models/categoryModel");
const Product = require("../models/productModel");
const Sales = require("../models/salesModel");
const User = require("../models/userModel");
const Expenses = require("../models/expensesModel");
const Debtors = require("../models/debtorsModel");
const Suppliers = require("../models/suppliersModel");
const Customers = require("../models/customerModel");

exports.getNumbers = async (req, res) => {
  const stocklimit = await Outofstocklimit.findOne(req.params.outofstocklimit);
  const intervals = await Outofstockintervals.findOne(
    req.params.stockintervals
  );
  var date = new Date();
  var date10 = new Date(date.getTime());
  date10.setDate(date10.getDate() + 10);
  try {
    const users = await User.countDocuments();
    const suppliers = await Suppliers.countDocuments();
    const customers = await Customers.countDocuments();
    const debtors = await Debtors.countDocuments();
    const categories = await Category.countDocuments();
    const products = await Product.countDocuments();
    const productsInstock = await Product.countDocuments({
      $expr: { $gt: [{ $toDouble: "$quantity" }, stocklimit?.stocklimit] },
    });
    const productsOutOfStock = await Product.countDocuments({
      $expr: { $lte: [{ $toDouble: "$quantity" }, stocklimit?.stocklimit] },
    });

    const productAboutToOutofStock = await Product.countDocuments({
      $and: [
        {
          $expr: { $gte: [{ $toDouble: "$quantity" }, intervals?.intervalone] },
        },
        {
          $expr: { $lte: [{ $toDouble: "$quantity" }, intervals?.intervaltwo] },
        },
      ],
    });
    const expiredProduct = await Product.countDocuments({
      expireDate: { $lte: new Date() },
      hideExpireDate: { $ne: false },
    });

    const productsAboutToExpire = await Product.countDocuments({
      expireDate: { $lte: new Date(date10), $gte: new Date() },
      hideExpireDate: { $ne: false },
    });
    const activeproducts = await Product.countDocuments({ active: true });
    const usersInactive = await User.countDocuments({ active: false });

    const debtorsHistoryWithPaymentAgg = await DebtorsHistory.aggregate([
      {
        $match: {
          "paymentHistory.paid_amount": { $exists: true, $gt: 0 },
        },
      },
      {
        $unwind: "$paymentHistory",
      },
      {
        $match: {
          "paymentHistory.paid_amount": { $gt: 0 },
        },
      },
      {
        $group: {
          _id: null,
          totalPaidAmount: { $sum: "$paymentHistory.paid_amount" },
        },
      },
    ]);
    const creditSalesTotalAgg = await DebtorsHistory.aggregate([
      {
        $match: {
          paymentMethod: "Credit",
        },
      },
      {
        $group: {
          _id: null,
          totalCreditSales: { $sum: "$grandTotal" },
          count: { $sum: 1 }, // Optional: count of credit sales
        },
      },
    ]);

    const expenses = await Expenses.aggregate([
      {
        $group: {
          _id: null,
          totalExpenses: { $sum: "$amount" },
        },
      },
    ]);

    const salesSummary = await Sales.aggregate([
      {
        $group: {
          _id: null,
          cashSales: {
            $sum: {
              $cond: [{ $eq: ["$paymentMethod", "Cash"] }, "$grandTotal", 0],
            },
          },
          mobileMoneySales: {
            $sum: {
              $cond: [
                { $eq: ["$paymentMethod", "MobileMoney"] },
                "$grandTotal",
                0,
              ],
            },
          },
          giftSales: {
            $sum: {
              $cond: [{ $eq: ["$paymentMethod", "Gift"] }, "$grandTotal", 0],
            },
          },
        },
      },
      {
        $project: {
          _id: 0,
          paymentMethods: {
            cash: "$cashSales",
            mobileMoney: "$mobileMoneySales",
            gift: "$giftSales",
          },
          totalSales: {
            $add: [
              { $ifNull: ["$cashSales", 0] },
              { $ifNull: ["$mobileMoneySales", 0] },
              { $ifNull: ["$giftSales", 0] },
            ],
          },
        },
      },
    ]);
    // Default to 0 if result is empty
    const totalPaidAmount =
      debtorsHistoryWithPaymentAgg[0]?.totalPaidAmount || 0;
    return res.json({
      users,
      debtors,
      suppliers,
      customers,
      categories,
      products,
      activeproducts,
      usersInactive,
      expiredProduct,
      productsInstock,
      productsOutOfStock,
      expenses: expenses[0]?.totalExpenses,
      totalSales:
        creditSalesTotalAgg[0]?.totalCreditSales +
          salesSummary[0]?.totalSales || 0,
      // totalSales: salesSummary[0]?.totalSales + totalPaidAmount || 0,
      cashSales: salesSummary[0]?.paymentMethods?.cash,
      totalCashSales: salesSummary[0]?.totalSales,
      mobilemoney: salesSummary[0]?.paymentMethods?.mobileMoney,
      gift: salesSummary[0]?.paymentMethods?.gift,
      creditSales: creditSalesTotalAgg[0]?.totalCreditSales,
      productsAboutToExpire,
      productAboutToOutofStock,
    });
  } catch (err) {
    console.log(err);
  }
};
