const Product = require("../models/productModel");
const catchAsync = require("../utils/catchAsync");
const AppError = require("../utils/appError");

exports.getAllProductsForMobile = catchAsync(async (req, res) => {
  const perPage = 35;
  const page = req.query.page ? req.query.page : 1;
  const products = await Product.find({ active: true })
    .select("+active")
    .skip((page - 1) * perPage)
    .limit(perPage)
    .sort({ createdAt: -1 })
    .populate("category", "_id name slug")
    .populate("user", "_id name");
  res.status(200).send(products);
});
