const RecycleBin = require("../models/recycleBinModel");
const mongoose = require("mongoose");

exports.deleteDocument = async (req, res) => {
  const { id } = req.params;
  const { collectionName } = req.body; // Assuming collectionName is passed in the request body
  console.log(collectionName);
  try {
    // Get the model dynamically
    const Model = mongoose.model(collectionName);

    if (!Model) {
      return res.status(404).send({ message: "Model not found" });
    }
    // Find the document to be deleted
    const document = await Model.findById(id);
    if (!document) {
      return res.status(404).send({ message: "Document not found" });
    }
    // Create a new entry in the recycle bin
    await RecycleBin.create({
      collectionName,
      documentId: document._id,
      document: document.toObject(),
      user: req.user._id,
    });
    // Remove the document from the original collection
    await Model.findByIdAndRemove(id);
    res.status(200).send({ message: "Document moved to recycle bin" });
  } catch (error) {
    console.error("Error deleting document:", error);
    res.status(500).send("Error deleting document");
  }
};
exports.getAllRecycleBinDocuments = async (req, res) => {
  try {
    // Remove the entry from the recycle bin
    const results = await RecycleBin.find({})
      .sort({ deletedAt: -1 })
      .populate("user", "username name email contactNum");
    res.status(200).send(results);
  } catch (error) {
    console.error("Error permanently deleting document:", error);
    res.status(500).send("Error permanently deleting document");
  }
};
exports.restoreDocument = async (req, res) => {
  const { id } = req.params;
  try {
    // Find the recycle bin entry
    const recycleBinEntry = await RecycleBin.findById(id);
    if (!recycleBinEntry) {
      return res.status(404).send({ message: "Recycle bin entry not found" });
    }
    // Get the model dynamically
    const Model = mongoose.model(recycleBinEntry.collectionName);
    // Restore the document to the original collection
    await Model.create(recycleBinEntry.document);
    // Remove the entry from the recycle bin
    await RecycleBin.findByIdAndRemove(id);

    res.status(200).send({ message: "Document restored successfully" });
  } catch (error) {
    console.error("Error restoring document:", error);
    res.status(500).send("Error restoring document");
  }
};

exports.permanentlyDeleteDocuments = async (req, res) => {
  const { ids } = req.body; // Assuming an array of IDs is passed in the request body
  try {
    // Remove the entries from the recycle bin
    const result = await RecycleBin.deleteMany({
      _id: { $in: ids },
    });

    if (result.deletedCount === 0) {
      return res.status(404).send({ message: "No recycle bin entries found" });
    }

    res.status(200).send({
      message: `${result.deletedCount} documents permanently deleted`,
    });
  } catch (error) {
    console.error("Error permanently deleting documents:", error);
    res.status(500).send("Error permanently deleting documents");
  }
};
