const Settings = require("../models/settingsModel");
const Outofstocklimit = require("../models/outofstocklimitModel");
const Outofstockintervals = require("../models/outofstockIntervalsModel");
const DeletionFrequency = require("../models/deletionFrequencyModel");
const ExchangeRates = require("../models/exchangeRatesModel");
const catchAsync = require("../utils/catchAsync");
const fs = require("fs");
const multer = require("multer");
const sharp = require("sharp");
const multerStorage = multer.memoryStorage();

const multerFilter = (req, file, cb) => {
  if (file.mimetype.startsWith("image")) {
    cb(null, true);
  } else {
    cb(new AppError("Not an image! Please upload only images.", 400), false);
  }
};

const upload = multer({
  storage: multerStorage,
  fileFilter: multerFilter,
});

exports.uploadLogo = upload.single("logo");

exports.resizeLogo = catchAsync(async (req, res, next) => {
  if (!req.file) return next();

  req.file.filename = `logo-${Date.now()}.jpeg`;
  await sharp(req.file.buffer).toFile(`../public/logo/${req.file.filename}`);
  next();
});

exports.createCompanyDetails = async (req, res) => {
  try {
    const { slug, companyName, address, email, contactNumber, description } =
      req.body;

    const found = await Settings.findOne({ slug });
    // const uploadedFilename = req.file ? req.file.filename : "";

    // if (uploadedFilename && found?.logo) {
    //   const filePath = `../public/logo/${found?.logo}`;
    //   fs.unlink(filePath, (err) => {
    //     if (err) {
    //       console.log(err);
    //     }
    //   });
    // }

    if (found) {
      const updated = await Settings.findOneAndUpdate(
        { slug },
        {
          companyName: companyName || found.companyName,

          address: address || found.address,
          email: email || found.email,

          description: description || found.description,
          contactNumber: contactNumber || found.contactNumber,
        },
        {
          new: true,
        }
      );
      return res.json(updated);
    } else {
      // create
      const created = await new Settings({
        ...req.body,
        // logo: uploadedFilename,
      }).save();
      return res.json(created);
    }
  } catch (err) {
    console.log(err);
  }
};

exports.getCompanyDetails = async (req, res) => {
  try {
    const { slug } = req.params;

    const found = await Settings.findOne(slug);
    return res.json(found);
  } catch (err) {
    console.log(err);
  }
};

exports.createOutofstockLimit = async (req, res) => {
  try {
    const { stocklimit, slug } = req.body;
    const found = await Outofstocklimit.findOne({ slug });

    if (found) {
      const updated = await Outofstocklimit.findOneAndUpdate(
        { slug },
        {
          stocklimit: stocklimit || found.stocklimit,
        },
        {
          new: true,
        }
      );
      return res.json(updated);
    } else {
      // create
      const created = await new Outofstocklimit({
        ...req.body,
      }).save();
      return res.json(created);
    }
  } catch (err) {
    console.log(err);
  }
};

exports.getOutofstocklimit = async (req, res) => {
  try {
    const { slug } = req.params;

    const found = await Outofstocklimit.findOne(slug);
    return res.json(found);
  } catch (err) {
    console.log(err);
  }
};

exports.createOutofstockIntervals = async (req, res) => {
  try {
    const { intervalone, intervaltwo, slug } = req.body;
    const found = await Outofstockintervals.findOne({ slug });

    if (found) {
      const updated = await Outofstockintervals.findOneAndUpdate(
        { slug },
        {
          intervalone: intervalone || found.intervalone,
          intervaltwo: intervaltwo || found.intervaltwo,
        },
        {
          new: true,
        }
      );
      return res.json(updated);
    } else {
      // create
      const created = await new Outofstockintervals({
        ...req.body,
      }).save();
      return res.json(created);
    }
  } catch (err) {
    console.log(err);
  }
};

exports.getOutofstockIntervals = async (req, res) => {
  try {
    const { slug } = req.params;

    const found = await Outofstockintervals.findOne(slug);
    return res.json(found);
  } catch (err) {
    console.log(err);
  }
};

exports.createExchangeRates = async (req, res) => {
  const { GHS, CFA, activeCurrency, slug } = req.body;

  try {
    const found = await ExchangeRates.findOne({ slug });
    if (found) {
      const updated = await ExchangeRates.findOneAndUpdate(
        { slug },
        {
          GHS: GHS || found.GHS,
          CFA: CFA || found.CFA,
          activeCurrency: activeCurrency || found.activeCurrency,
        },
        {
          new: true,
        }
      );
      return res.status(200).json(updated);
    } else {
      // create
      const created = await new ExchangeRates({
        ...req.body,
      }).save();
      return res.status(200).json(created);
    }
  } catch (err) {
    console.log(err);
  }
};

exports.getExchangeRates = async (req, res) => {
  try {
    const { slug } = req.params;

    const found = await ExchangeRates.findOne(slug);
    return res.json(found);
  } catch (err) {
    console.log(err);
  }
};

exports.createDeletionFrequency = async (req, res) => {
  try {
    const { name, slug } = req.body;
    const found = await DeletionFrequency.findOne({ slug });
    if (found) {
      const updated = await DeletionFrequency.findOneAndUpdate(
        { slug },
        {
          name: name || found.name,
        },
        {
          new: true,
        }
      );
      return res.json(updated);
    } else {
      // create
      const created = await new DeletionFrequency({
        ...req.body,
      }).save();
      return res.json(created);
    }
  } catch (err) {
    console.log(err);
  }
};

exports.getDeletionFrequency = async (req, res) => {
  try {
    const { slug } = req.params;
    const found = await DeletionFrequency.findOne(slug);
    return res.json(found);
  } catch (err) {
    console.log(err);
  }
};
