const Shop = require("../models/shopsModel");
const slugify = require("slugify");
const catchAsync = require("../utils/catchAsync");
const AppError = require("../utils/appError");
const { generate10DigitUUID } = require("../helpers/generater");

exports.createShops = catchAsync(async (req, res, next) => {
  const { shopname } = req.body;
  let slug = slugify(shopname) + generate10DigitUUID();
  const alreadyExist = await Shop.findOne({ shopname });
  if (alreadyExist) {
    return next(new AppError("Shop name already exist", 400));
  }

  let shop = await new Shop({
    shopname,
    slug,
  }).save();

  res.status(200).send(shop);
});

exports.getShops = catchAsync(async (req, res, next) => {
  const shop = await Shop.find({}).sort({ createdAt: 1 });
  res.status(200).send(shop);
});
