const { v4: uuidv4 } = require("uuid");

exports.generateUniqueCode = () => {
  const uuid = uuidv4().replace(/-/g, ""); // Remove hyphens from UUID
  const base62Chars =
    "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
  const base62Uuid = uuid
    .match(/.{1,2}/g) // Split into 2-character chunks
    .map((chunk) => parseInt(chunk, 16) % 62) // Convert to base-62 index
    .map((index) => base62Chars[index]) // Map to base-62 characters
    .join("");

  return base62Uuid.slice(0, 10); // Ensure exactly 10 characters
};
