const Sale = require("../models/salesModel");
// const admin = require("../firebase"); // Firebase Admin SDK

const sendDailySalesSummary = async (userId, fcmToken) => {
  const today = new Date();
  const start = new Date(today.setHours(0, 0, 0, 0));
  const end = new Date(today.setHours(23, 59, 59, 999));

  const sales = await Sale.aggregate([
    { $match: { user: userId, createdAt: { $gte: start, $lte: end } } },
    {
      $group: {
        _id: null,
        total: { $sum: "$totalAmount" },
        count: { $sum: 1 },
      },
    },
  ]);

  const { total = 0, count = 0 } = sales[0] || {};

  const message = {
    notification: {
      title: "📊 Daily Sales Summary",
      body: `You made ${count} sales totaling GHS ${total.toFixed(2)} today.`,
    },
    token: fcmToken,
  };

  //   await admin.messaging().send(message);
};
module.exports = sendDailySalesSummary;
