// Assuming you're using Mongoose for MongoDB ODM
const mongoose = require("mongoose");

// Define Schema for Activity Tracker
const activityTrackerSchema = new mongoose.Schema(
  {
    user: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
      ref: "User", // Assuming you have a User model
    },
    details: {
      type: Object,
      default: {},
      // type: Schema.Types.Mixed,
    },
    activityType: {
      type: String,
      enum: [
        "login",
        "sales",
        "sales_report_update",
        "purchase",
        "purchase_report_update",
        "product_added",
        "product_updated",
        "product_deleted",
        "product_inactive",
        "product_active",
        "product_activeinactive",
        "category_added",
        "stocktake",
        "category_deleted",
        "category_updated",
        "bulk_import",
        "expenses_added",
        "expenses_updated",
        "expenses_deleted",
        "user_added",
        "transfer",
        "remove_product_from_transfer",
        "remove_transfer",
        "update_sales",
        "sales_product_delete",
        "purchase_product_delete",
        "delete_purchase",
        "purchase_order",
        "update_stocktake",
        "delete_product_instock",
        "delete_stocktake",
        "transfer_product_delete",
        "stock_take",
        "salary_added",
        "salary_deleted",
        "salary_updated",
      ], // Define your activity types
      required: true,
    },
  },
  { timestamps: true }
);

// Define Activity model

module.exports = mongoose.model("ActivityTracker", activityTrackerSchema);
