const mongoose = require("mongoose");
const { Schema } = mongoose;

const cartSchema = new Schema(
  {
    user: {
      type: Schema.Types.ObjectId,
      ref: "User",
    },
    items: {
      type: [Schema.Types.Mixed], // Flexible array of objects
      default: [],
    },
    status: {
      type: String,
      default: "active",
      enum: ["active", "abandoned", "completed"],
    },
  },
  {
    timestamps: true,
    toJSON: { virtuals: true },
    toObject: { virtuals: true },
  }
);

// Virtual for total items count
cartSchema.virtual("totalItems").get(function () {
  return this.items.reduce((total, item) => total + (item.quantity || 0), 0);
});

// Virtual for subtotal calculation
cartSchema.virtual("subtotal").get(function () {
  return this.items.reduce(
    (total, item) => total + (item.quantity || 0) * (item.sellingPrice || 0),
    0
  );
});
module.exports = mongoose.model("Cart", cartSchema);
