const mongoose = require("mongoose");
const Debtors = require("./debtorsModel");
const User = require("./userModel");
const Product = require("../models/productModel");
const Customers = require("./customerModel");
const { Schema } = mongoose;

const paidhistorySchema = new Schema(
  {
    paid_amount: {
      type: Number,
      required: true,
    },

    date_paid: {
      type: Date,
      required: true,
    },
  },
  { timestamps: true }
);

const debtorsHistorySchema = new Schema(
  {
    customer: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Customers",
    },
    products: {
      type: Array,
      require: true,
    },
    debtor: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Debtors",
    },
    amount_remaining: {
      type: Number,
    },
    dateTime: {
      type: Date,
      require: true,
      default: Date.now,
    },
    subTotal: {
      type: Number,
      require: true,
    },
    grandTotal: {
      type: Number,
      require: true,
    },
    currency: {
      type: String,
      default: "GH",
    },
    receivedAmount: {
      type: Number,
      require: true,
    },
    paymentMethod: {
      type: String,
      default: "Cash",
      require: true,
      enum: ["Cash", "MobileMoney", "Gift", "Credit"],
    },
    balance: {
      type: Number,
      require: true,
    },
    quantitySold: {
      type: Number,
      require: true,
    },
    invoiceID: {
      type: String,
      unique: true,
      index: true,
    },
    seller: {
      type: mongoose.Schema.Types.ObjectId,
      ref: User,
    },
    discount: [
      {
        product: {
          type: mongoose.Schema.Types.ObjectId,
          ref: Product,
          required: true,
        },
        discount: Number,
      },
    ],
    paymentHistory: [paidhistorySchema],
  },
  { timestamps: true }
);

module.exports = mongoose.model("DebtorsHistory", debtorsHistorySchema);
