const mongoose = require("mongoose");
const { Schema } = mongoose;

const exchangeRatesSchema = new Schema(
  {
    GHS: {
      type: String,
      trim: true,
      required: true,
    },

    CFA: {
      type: String,
      trim: true,
      required: true,
    },
    activeCurrency: {
      type: String,
      default: "GHC",
    },

    slug: {
      type: String,
      unique: true,
      index: true,
      lowercase: true,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("ExchangeRates", exchangeRatesSchema);
