const mongoose = require("mongoose");
const { Schema } = mongoose;
const User = require("./userModel");
const Salary = require("./salaryModel");

const expensesSchema = new Schema(
  {
    name: {
      type: String,
      trim: true,
      required: [true, "Name is required"],
    },
    salary: {
      type: mongoose.Schema.Types.ObjectId,
      ref: Salary,
    },
    amount: {
      type: Number,
      trim: true,
      required: [true, "Amount is required"],
    },

    date: {
      type: Date,
      required: true,
      trim: true,
    },
    user: {
      type: mongoose.Schema.Types.ObjectId,
      ref: User,
    },
    slug: {
      type: String,
      unique: true,
      index: true,
      lowercase: true,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("Expenses", expensesSchema);
