const mongoose = require("mongoose");

const notificationSchema = new mongoose.Schema({
  user: { type: mongoose.Schema.Types.ObjectId, ref: "User", required: true },
  type: {
    type: String,
    enum: [
      "sale",
      "daily_summary",
      "product_expiry",
      "out_of_stock",
      "salary_reminder",
    ],
    required: true,
  },
  message: { type: String, required: true },
  title: { type: String, required: true },
  saleId: { type: mongoose.Schema.Types.ObjectId, ref: "Sales" },
  read: { type: Boolean, default: false },
  createdAt: { type: Date, default: Date.now },
});

module.exports = mongoose.model("Notification", notificationSchema);
