const Category = require("./categoryModel");
const User = require("./userModel");

const mongoose = require("mongoose");
const { Schema } = mongoose;

const productSchema = new Schema(
  {
    name: {
      type: String,
      required: true,
      trim: true,
    },

    quantity: {
      type: Number,
      required: true,
      trim: true,
      default: 0,
    },
    barcode: {
      type: Number,
      trim: true,
    },

    initialQty: {
      type: Number,
      default: 0,
    },

    costPrice: {
      type: Number,
      trim: true,
      default: 0,
    },

    sellingPrice: {
      type: Number,
      trim: true,
      default: 0,
    },
    salesreturnQty: {
      type: Number,
      default: 0,
    },
    purchasereturnQty: {
      type: Number,
      default: 0,
    },
    varianceAmt: {
      type: Number,
      default: 0,
    },
    varianceQty: {
      type: Number,
      default: 0,
    },

    active: {
      type: Boolean,
      default: true,
      select: false,
    },
    expireDate: {
      type: Date,
      trim: true,
    },
    hideExpireDate: {
      type: Boolean,
      default: true,
    },

    category: [{ type: mongoose.Schema.Types.ObjectId, ref: Category }],

    user: { type: mongoose.Schema.Types.ObjectId, ref: User },

    slug: {
      type: String,
      required: true,
      unique: false,
      index: true,
      lowercase: true,
    },
    purchaseReturnReasons: {
      type: String,
      trim: true,
      default: "",
    },
    salesReturnReasons: {
      type: String,
      trim: true,
      default: "",
    },
    itemDiscrepancyReasons: {
      type: String,
      trim: true,
      default: "",
    },
  },

  { timestamps: true }
);

productSchema.virtual("id").get(function () {
  return this._id.toHexString();
});

productSchema.set("toJSON", {
  virtuals: true,
});

module.exports = mongoose.model("Product", productSchema);
