const mongoose = require("mongoose");
const { Schema } = mongoose;
const User = require("./userModel");
const Suppliers = require("./suppliersModel");
const StartingBalance = require("./startingBalanceModel");

const purchaseSchema = new Schema(
  {
    products: {
      type: Array,
      required: true,
    },
    purchaseTime: {
      type: Date,
      required: true,
    },
    invoiceNumber: {
      type: String,
      unique: true,
      index: true,
    },
    grandQuantity: {
      type: Number,
      required: true,
    },
    supplier: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Suppliers",
      required: true,
    },
    user: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    amount: {
      type: Number,
      required: true,
    },
    paidAmount: {
      type: Number,
      default: 0,
    },
    balance: {
      type: Number,
      default: 0,
    },
  },
  { timestamps: true }
);

// Middleware to update balance before saving
purchaseSchema.pre("save", async function (next) {
  try {
    // Ensure required fields are present
    if (!this.supplier || !this.amount) {
      throw new Error(
        "Supplier and amount are required for balance calculation"
      );
    }

    // Fetch the starting balance for the supplier
    // const startingBalance = await StartingBalance.findOne({
    //   supplier: this.supplier,
    // });
    // const previousDebt = startingBalance?.amount || 0;

    // Calculate balance correctly
    this.balance = this.amount - this.paidAmount;

    // Log the calculated balance for debugging

    next();
  } catch (error) {
    console.error("Error in pre-save middleware:", error.message);
    next(error);
  }
});
module.exports = mongoose.model("Purchase", purchaseSchema);
