const mongoose = require("mongoose");
const { Schema } = mongoose;
const User = require("./userModel");
const Suppliers = require("./suppliersModel");

const purchaseOrderSchema = new Schema(
  {
    products: {
      type: Array,
      require: true,
    },
    purchaseTime: {
      type: Date,
      default: Date.now,
      require: true,
    },
    invoiceID: {
      type: String,
      unique: true,
      index: true,
    },
    grandQuantity: {
      type: Number,
      require: true,
    },
    supplier: {
      type: mongoose.Schema.Types.ObjectId,
      ref: Suppliers,
    },
    user: {
      type: mongoose.Schema.Types.ObjectId,
      ref: User,
    },
    amount: {
      type: Number,
      required: true,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("PurchaseOrder", purchaseOrderSchema);
