const mongoose = require("mongoose");
const { Schema } = mongoose;

const purchasesReturnsSchema = new Schema(
  {
    product: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Product",
      required: true,
    },
    user: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
      ref: "User",
    },
    purchaseReturnReasons: {
      type: String,
      trim: true,
      default: "",
    },
    newQuantity: {
      type: Number,
      required: true,

      default: 0,
    },
    previousQuantity: {
      type: Number,
      required: true,
      default: 0,
    },
    purchasereturnQty: {
      type: Number,
      required: true,
      default: 0,
    },
    remainingPurchaseReturnQty: {
      type: Number,
      required: true,
      default: 0,
    },
    // currentQty: {
    //   type: Number,
    //   required: true,
    //   default: 0,
    // },

    purchaseId: {
      type: String,
      required: true,
      trim: true,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("purchasesReturns", purchasesReturnsSchema);
