const mongoose = require("mongoose");
const Schema = mongoose.Schema;
const User = require("./userModel");

const recycleBinSchema = new Schema({
  collectionName: { type: String, required: true },
  documentId: { type: Schema.Types.ObjectId, required: true },
  document: { type: Schema.Types.Mixed, required: true },
  deletedAt: { type: Date, default: Date.now },
  user: {
    type: mongoose.Schema.Types.ObjectId,
    ref: User,
  },
});

const RecycleBin = mongoose.model("RecycleBin", recycleBinSchema);

module.exports = RecycleBin;
