const mongoose = require("mongoose");
const User = require("./userModel");

const salarySchema = new mongoose.Schema(
  {
    employee: {
      type: mongoose.Schema.Types.ObjectId,
      ref: User,
    },
    date: {
      type: Date,
      required: [true, "Payment date is required"],
      default: Date.now,
    },

    amount: {
      type: Number,
      required: [true, "Amount is required"],
      min: [0, "Amount cannot be negative"],
    },

    paymentMethod: {
      type: String,
      required: [true, "Payment method is required"],
      enum: {
        values: [
          "Direct Deposit",
          "Check",
          "Bank Transfer",
          "Cash",
          "Mobile Money",
        ],
        message: "Invalid payment method",
      },
      default: "Direct Deposit",
    },

    notes: {
      type: String,
      trim: true,
      maxlength: [500, "Notes cannot exceed 500 characters"],
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("Salary", salarySchema);
