const User = require("./userModel");
const Customers = require("./customerModel");
const Product = require("./productModel");
const mongoose = require("mongoose");
const { Schema } = mongoose;

const salesSchema = new Schema(
  {
    customer: {
      type: mongoose.Schema.Types.ObjectId,
      ref: Customers,
      default: null, // Set default to null
    },

    products: {
      type: Array,
      require: true,
    },
    dateTime: {
      type: Date,
      require: true,
      default: Date.now,
    },
    subTotal: {
      type: Number,
      require: true,
    },
    grandTotal: {
      type: Number,
      require: true,
    },
    currency: {
      type: String,
      default: "GH",
    },
    receivedAmount: {
      type: Number,
      require: true,
    },
    paymentMethod: {
      type: String,
      default: "Cash",
      require: true,
      enum: ["Cash", "MobileMoney", "Gift", "Credit"],
    },
    balance: {
      type: Number,
      require: true,
    },
    quantitySold: {
      type: Number,
      require: true,
    },
    invoiceID: {
      type: String,
      unique: true,
      index: true,
    },
    seller: {
      type: mongoose.Schema.Types.ObjectId,
      ref: User,
    },
    discount: [
      {
        product: {
          type: mongoose.Schema.Types.ObjectId,
          ref: Product,
          required: true,
        },
        discount: Number,
      },
    ],
  },
  { timestamps: true }
);

module.exports = mongoose.model("Sales", salesSchema);
