const mongoose = require("mongoose");
const { Schema } = mongoose;

const salesReturnsSchema = new Schema(
  {
    product: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Product",
      required: true,
    },
    user: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
      ref: "User",
    },
    salesReturnReasons: {
      type: String,
      trim: true,
      default: "",
    },
    newQuantity: {
      type: Number,
      required: true,
      trim: true,
      default: 0,
    },
    previousQuantity: {
      type: Number,
      required: true,
      trim: true,
      default: 0,
    },
    salesreturnQty: {
      type: Number,
      required: true,
      trim: true,
      default: 0,
    },

    salesId: {
      type: String,
      required: true,
      trim: true,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("salesReturns", salesReturnsSchema);
