const mongoose = require("mongoose");
const { Schema } = mongoose;

const settingsSchema = new Schema(
  {
    companyName: {
      type: String,
      trim: true,
      required: true,
      unique: true,
      max: 32,
    },
    address: {
      type: String,
      trim: true,
      max: 32,
    },
    email: {
      type: String,
      trim: true,
      unique: true,
      max: 32,
    },
    contactNumber: {
      type: String,
      trim: true,
      unique: true,
    },

    description: {
      type: {},
      trim: true,
      max: 2000000,
    },
    slug: {
      type: String,
      unique: true,
      index: true,
      lowercase: true,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("Settings", settingsSchema);
