const mongoose = require("mongoose");
const { Schema } = mongoose;

const shopsSchema = new Schema(
  {
    shopname: {
      type: String,
      trim: true,
      required: true,
    },
    slug: {
      type: String,
      unique: true,
      index: true,
      lowercase: true,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("Shop", shopsSchema); // Changed model name to "Shop"
