const mongoose = require("mongoose");
const { Schema } = mongoose;

const startingBalanceHistorySchema = new Schema(
  {
    startingBalance: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "StartingBalance",
      required: true,
    },
    oldAmount: { type: Number, required: true }, // The amount before the update
    repaidAmount: { type: Number, required: true }, // The amount before the update
    newAmount: { type: Number, required: true }, // The amount after the update
    updatedBy: { type: mongoose.Schema.Types.ObjectId, ref: "User" }, // Optional: Track who made the update
    notes: { type: String, default: "" }, // Optional: Add notes for the update
  },
  { timestamps: true }
);

module.exports = mongoose.model(
  "StartingBalanceHistory",
  startingBalanceHistorySchema
);
