// models/startingBalanceModel.js
const mongoose = require("mongoose");
const { Schema } = mongoose;
const Suppliers = require("./suppliersModel");

const startingBalanceSchema = new Schema(
  {
    supplier: {
      type: mongoose.Schema.Types.ObjectId,
      ref: Suppliers,
      required: true,
    },
    amount: { type: Number, required: true }, // Historical debt owed to the supplier
  },
  { timestamps: true }
);

module.exports = mongoose.model("StartingBalance", startingBalanceSchema);
