const mongoose = require("mongoose");
const { Schema } = mongoose;
const User = require("./userModel");

const stokeTakeSchema = new Schema(
  {
    products: {
      type: Array,
      require: true,
    },
    stockTakeTime: {
      type: Date,
      default: Date.now,
      require: true,
    },
    grandQuantity: {
      type: Number,
      require: true,
    },

    user: {
      type: mongoose.Schema.Types.ObjectId,
      ref: User,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("StokeTake", stokeTakeSchema);
