const mongoose = require("mongoose");
const { Schema } = mongoose;
const User = require("./userModel");

const suppliersSchema = new Schema(
  {
    name: {
      type: String,
      trim: true,
      required: [true, "Name is required"],
    },
    contact: {
      type: String,
      trim: true,
      required: [true, "Contact is required"],
    },
    address: {
      type: String,
      trim: true,
    },
    user: {
      type: mongoose.Schema.Types.ObjectId,
      ref: User,
    },
    slug: {
      type: String,
      unique: true,
      index: true,
      lowercase: true,
    },
    currentBalance: { type: Number, default: 0 },
  },
  { timestamps: true }
);

module.exports = mongoose.model("Suppliers", suppliersSchema);
