const mongoose = require("mongoose");
const { Schema } = mongoose;
const Purchase = require("./purchaseModel");
const StartingBalance = require("./startingBalanceModel");

const suppliersPaymentSchema = new Schema(
  {
    purchase: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "Purchase",
      required: true,
    },
    amount: { type: Number, required: true },
    notes: { type: String, default: "" },
  },
  { timestamps: true }
);

// Middleware to update purchase balance and starting balance when payment is made
// suppliersPaymentSchema.post("save", async function (doc, next) {
//   try {
//     const purchase = await Purchase.findById(doc.purchase);
//     if (!purchase) return next();

//     // Update the paidAmount in the Purchase document

//     // Fetch the starting balance for the supplier
//     const startingBalance = await StartingBalance.findOne({
//       supplier: purchase.supplier,
//     });

//     // Adjust the starting balance if it exists
//     if (startingBalance && startingBalance.amount > 0) {
//       const remainingDebt = startingBalance.amount - doc.amount;
//       startingBalance.amount = remainingDebt >= 0 ? remainingDebt : 0;
//       await startingBalance.save();
//     }

//     next();
//   } catch (error) {
//     next(error);
//   }
// });

module.exports = mongoose.model("SuppliersPayment", suppliersPaymentSchema);
