const mongoose = require("mongoose");

const TallyCardSchema = new mongoose.Schema({
  product: {
    type: mongoose.Schema.Types.ObjectId,
    required: true,
    ref: "Product", // Assuming you have a User model
  },
  user: {
    type: mongoose.Schema.Types.ObjectId,
    required: true,
    ref: "User", // Assuming you have a User model
  },
  description: {
    type: String,
  },
  inflow: {
    type: Number,
    default: 0,
  },
  outflow: {
    type: Number,
    required: true,
  },
  previousQty: {
    type: Number,
    default: 0,
  },
  stockBalance: {
    type: Number,
    required: true,
  },
  stokeId: {
    type: String,
  },
  salesId: {
    type: String,
  },
  purchaseId: {
    type: String,
  },
  transferId: {
    type: String,
  },
  date: {
    type: Date,
    default: Date.now,
  },
});

module.exports = mongoose.model("TallyCard", TallyCardSchema);
