const User = require("./userModel");
const Shop = require("./shopsModel");
const Products = require("./productModel");
const mongoose = require("mongoose");
const { Schema } = mongoose;

const transferSchema = new Schema(
  {
    user: {
      type: mongoose.Schema.Types.ObjectId,
      ref: User,
    },
    // products: [{ type: mongoose.Schema.Types.ObjectId, ref: Products }],
    shop: {
      type: mongoose.Schema.Types.ObjectId,
      ref: Shop,
    },
    quantity: {
      type: Number,
      require: true,
    },
    products: {
      type: Array,
      require: true,
    },
    amount: {
      type: Number,
      require: true,
    },
    transferType: {
      type: String,
      require: true,
    },
    documentNumber: {
      type: String,
      require: true,
    },
    purchaseTime: {
      type: Date,
      require: true,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("Transfer", transferSchema);
