const mongoose = require("mongoose");
const { Schema } = mongoose;
const Menu = require("./menuModel");
const Route = require("./routeModel");
const Role = require("./roleModel");
const Permission = require("./permissionModel");
const PushSubscription = require("./pushSubscriptionModel");

const userSchema = new Schema(
  {
    username: {
      type: String,
      trim: true,
      required: true,
      max: 32,
      unique: true,
      index: true,
      lowercase: true,
    },

    name: {
      trim: true,
      type: String,
      required: [true, "Please enter your name"],
      maxLength: [50, "Your name cannot exceed 50 characters"],
    },

    email: {
      type: String,
      unique: true,
      trim: true,
      required: [true, "Please enter your email"],
    },

    password: {
      type: String,
      trim: true,
      required: [true, "Please enter your password"],
      minlength: [6, "Your password must be longer than 6 characters"],
      select: false,
    },
    permissions: {
      type: mongoose.Types.ObjectId,
      ref: Permission,
    },
    role: { type: mongoose.Types.ObjectId, ref: Role }, // Reference to Role
    assignedRoutes: [{ type: mongoose.Types.ObjectId, ref: Route }], // Array of Routes
    menus: [{ type: mongoose.Types.ObjectId, ref: Menu }],
    combinedRoutes: [
      {
        type: {
          type: String,
          enum: ["menu", "submenu", "route"],
          required: true,
        },
        _id: { type: Schema.Types.ObjectId },
        path: { type: String },
        name: { type: String },
        parentMenu: { type: Schema.Types.ObjectId },
      },
    ], // Array to store combined menu items
    refreshToken: { type: String },
    contactNum: {
      type: String,
      unique: true,
      required: [true, "Please enter your phone number"],
    },
    active: {
      type: Boolean,
      default: true,
      select: false,
    },
    isActiveCombineRoute: {
      type: Boolean,
      default: false,
    },
    generatedPassword: {
      type: String,
    },
    profileimage: {
      type: String,
      default: "default.jpg",
    },
    pushSubscriptions: [
      {
        type: mongoose.Schema.Types.ObjectId,
        ref: PushSubscription,
      },
    ],

    last_login_date: {
      type: Date,
      default: Date.now,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("User", userSchema);
