const mongoose = require("mongoose");

const userPreferencesSchema = new mongoose.Schema(
  {
    user: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
      unique: true,
    },
    notificationPreferences: {
      instantSales: { type: Boolean, default: false },
      dailySummary: { type: Boolean, default: false },
      pushEnabled: { type: Boolean, default: false },
      emailEnabled: { type: Boolean, default: false },
      productExpiry: { type: Boolean, default: false },
      outofStock: { type: Boolean, default: false },
      salaryReminder: { type: Boolean, default: false }, // New field
    },
    dailySummaryTime: { type: String, default: "18:00" },
    salaryReminderDate: { type: Number, min: 1, max: 31, default: 25 }, // Day of month (1-31)
    salaryReminderTime: { type: String, default: "09:00" }, // Time of day (HH:mm)
    providedEmail: { type: String },
  },
  {
    timestamps: true, // Adds createdAt and updatedAt fields
  }
);

module.exports = mongoose.model("UserPreferences", userPreferencesSchema);

// const mongoose = require("mongoose");

// const userPreferencesSchema = new mongoose.Schema({
//   user: {
//     type: mongoose.Schema.Types.ObjectId,
//     ref: "User",
//     required: true,
//     unique: true,
//   },
//   notificationPreferences: {
//     instantSales: { type: Boolean, default: false },
//     dailySummary: { type: Boolean, default: false },
//     pushEnabled: { type: Boolean, default: false },
//     emailEnabled: { type: Boolean, default: false },
//     productExpiry: { type: Boolean, default: false },
//     outofStock: { type: Boolean, default: false },
//   },
//   dailySummaryTime: { type: String, default: "18:00" },
//   providedEmail: { type: String },
// });

// module.exports = mongoose.model("UserPreferences", userPreferencesSchema);
