const router = require("express").Router();
const {
  updateProfile,
  readUser,
  signOut,
  login,
  refreshToken,
} = require("../controllers/authController");
const { loadUser } = require("../controllers/generalController");

const {
  uploadUserPhoto,
  resizeUserPhoto,
} = require("../helpers/uploadprofileimage");

const { verifyToken } = require("../middlewares/authMiddleware");

router.route("/auth/signin").post(login);
router.route("/auth/signout").post(signOut);

router
  .route("/auth/profile")
  .get(verifyToken, loadUser, readUser)
  .put(verifyToken, loadUser, uploadUserPhoto, resizeUserPhoto, updateProfile);
router.post("/refresh-token", refreshToken);
module.exports = router;
