const router = require("express").Router();
const {
  addToCart,
  removeFromCart,
  getCartItems,
} = require("../controllers/cartController");
const { loadUser } = require("../controllers/generalController");
const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/qrcode-cart")
  .post(verifyToken, loadUser, addToCart)
  .get(verifyToken, loadUser, getCartItems);
router
  .route("/remove-from-cart/:productId")
  .delete(verifyToken, loadUser, removeFromCart);

module.exports = router;
