const router = require("express").Router();
const {
  createCategory,
  getAllCategories,
  deleteCategory,
  updateCategory,
} = require("../controllers/categoryController");
const { loadUser } = require("../controllers/generalController");
const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/categories")
  .get(verifyToken, loadUser, getAllCategories)
  .post(verifyToken, loadUser, createCategory);
router
  .route("/category/:id")
  .delete(verifyToken, loadUser, deleteCategory)
  .put(verifyToken, loadUser, updateCategory);

module.exports = router;
