const router = require("express").Router();
const {
  createCustomer,
  getAllCustomers,
  updateCustomer,
  read,
  adminGetCustomerSales,
} = require("../controllers/customerController");
const { loadUser } = require("../controllers/generalController");
const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/customers")
  .post(verifyToken, loadUser, createCustomer)
  .get(verifyToken, loadUser, getAllCustomers);

router
  .route("/customer/:id")
  .get(verifyToken, loadUser, read)
  .put(verifyToken, loadUser, updateCustomer);
router
  .route("/customer/sales/:customerId")
  .get(verifyToken, loadUser, adminGetCustomerSales);

module.exports = router;
