const router = require("express").Router();
const {
  createDebtor,
  getAllDebtors,
  read,
  updateDebtor,
  addPaidHistory,
  updatePaidHistory,
  createDebtorHistory,
  getDebtorHistory,
  creditSalesByDate,
  salesDebtorReturns,
} = require("../controllers/debtorsController");
const { loadUser } = require("../controllers/generalController");
const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/debtors")
  .post(verifyToken, loadUser, createDebtor)
  .get(verifyToken, loadUser, getAllDebtors);
router
  .route("/debtor/:id")
  .get(verifyToken, loadUser, read)
  .put(verifyToken, loadUser, updateDebtor);
router
  .route("/debtor/paidhistory/:id")
  .post(verifyToken, loadUser, addPaidHistory)
  .put(verifyToken, loadUser, updatePaidHistory);

router
  .route("/creadit/saleshistory")
  .get(verifyToken, loadUser, creditSalesByDate);
router
  .route("/credit/sales/update-sales/:productId")
  .put(verifyToken, loadUser, salesDebtorReturns);
router
  .route("/create/debtor-history")
  .post(verifyToken, loadUser, createDebtorHistory);
router
  .route("/load-debtor/history/:id")
  .get(verifyToken, loadUser, getDebtorHistory);

module.exports = router;
