const router = require("express").Router();
const {
  createExcess,
  getAllExcess,
  updateExcess,
} = require("../controllers/excessController");
const { loadUser } = require("../controllers/generalController");
const { verifyToken } = require("../middlewares/authMiddleware");

// POST /api/excess - Create new excess record
router
  .route("/excess")
  .post(verifyToken, loadUser, createExcess)
  .get(verifyToken, loadUser, getAllExcess);
router.route("/excess/:id").put(verifyToken, loadUser, updateExcess);

module.exports = router;
