const router = require("express").Router();
const {
  createExpenses,
  getAllExpenses,
  updateExpenses,
  getSingleExpenses,
  deleteExpenses,
  totalExpensesForSelectedDays,
} = require("../controllers/expensesController");
const { loadUser } = require("../controllers/generalController");
const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/expenses")
  .post(verifyToken, loadUser, createExpenses)
  .get(verifyToken, loadUser, getAllExpenses);
router
  .route("/expenses/:slug")
  .put(verifyToken, loadUser, updateExpenses)
  .get(verifyToken, loadUser, getSingleExpenses);
router.route("/expenses/:id").delete(verifyToken, loadUser, deleteExpenses);
router
  .route("/expenses/bydates")
  .post(verifyToken, loadUser, totalExpensesForSelectedDays);

module.exports = router;
