const { verifyToken } = require("../middlewares/authMiddleware");
const {
  loadUser,
  createMenu,
  createRoute,
  removeRouteFromRole,
  removeRouteFromUser,
  removeMenuFromRoute,
  assignRouteToMenu,
  assignMenuToUser,
  getAllRoles,
  getAllRoutes,
  getAllMenus,
  updateUserCombinedRoutes,
  getUserCombinedRoutes,
  assignRolesRoutesMenus,
} = require("../controllers/generalController");

const router = require("express").Router();

router.post(
  "/menu",
  verifyToken,
  // verifyRouteAccess("/remove-route"),
  createMenu
);

router.post(
  "/create-route",
  verifyToken,
  loadUser,
  // verifyRouteAccess("/create-route"),
  createRoute
);

router.patch(
  "/remove-route",
  verifyToken,
  // verifyRouteAccess("/remove-route"),
  removeRouteFromRole
);
router.get("/roles", verifyToken, loadUser, getAllRoles);
router.get("/routes", verifyToken, loadUser, getAllRoutes);
router.get("/menus", verifyToken, loadUser, getAllMenus);
router.patch(
  "/remove-user-route",
  verifyToken,
  // verifyRouteAccess("/remove-route"),
  removeRouteFromUser
);
router.delete(
  "/remove-menu-route",
  verifyToken,
  // verifyRouteAccess("/remove-route"),
  removeMenuFromRoute
);
router.patch(
  "/assign-route-menu",
  verifyToken,
  // verifyRouteAccess("/remove-route"),
  assignRouteToMenu
);
router.patch(
  "/assign-menu-user",
  verifyToken,
  // verifyRouteAccess("/remove-route"),
  assignMenuToUser
);
router.patch(
  "/assign-role-route-menus",
  verifyToken,
  loadUser,
  // verifyRouteAccess("/assign-role"),
  assignRolesRoutesMenus
);

router.post(
  "/users/updateRoutes",
  verifyToken,
  loadUser,
  updateUserCombinedRoutes
);
router.get(
  "/user/combinedroutes",
  verifyToken,
  loadUser,
  getUserCombinedRoutes
);

module.exports = router;
