const express = require("express");
const csvController = require("../controllers/csvController");
const importSalesBackLog = require("../controllers/csvController");
const multer = require("multer");
const fs = require("fs");
const path = require("path");
const { verifyToken } = require("../middlewares/authMiddleware");

const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    if (!fs.existsSync("public")) {
      fs.mkdirSync("public");
    }

    if (!fs.existsSync("public/csv")) {
      fs.mkdirSync("public/csv");
    }

    cb(null, "public/csv");
  },
  filename: function (req, file, cb) {
    cb(null, Date.now() + file.originalname);
  },
});

const upload = multer({
  storage: storage,
  fileFilter: function (req, file, cb) {
    var ext = path.extname(file.originalname);
    if (ext !== ".csv") {
      return cb(new Error("Only csvs are allowed!"));
    }

    cb(null, true);
  },
});

const router = express.Router();

//post create new media
router.post(
  "/uploadCsv",
  verifyToken,
  upload.single("csvFile"),
  csvController.ImportProducts
);

router.post(
  "/import/salesbacklog",
  verifyToken,
  upload.single("csvFile"),
  csvController.importSalesBackLog
);

module.exports = router;
