const router = require("express").Router();

const {
  getMaxConsumption,
  calculateMaxStock,
  calculateReorderLevels,
} = require("../controllers/consumptionController");
const { loadUser } = require("../controllers/generalController");
const { verifyToken } = require("../middlewares/authMiddleware");

router.route("/max-consumption").get(verifyToken, loadUser, getMaxConsumption);
router
  .route("/calculate-maxstock")
  .get(verifyToken, loadUser, calculateMaxStock);
router
  .route("/calculate-reorderlevels")
  .get(verifyToken, loadUser, calculateReorderLevels);

module.exports = router;
