const router = require("express").Router();

const {
  getUserNotifications,
  updateNotificationPreferences,
  registerPushSubscription,
  removePushSubscription,
} = require("../controllers/notificationController");
const { verifyToken } = require("../middlewares/authMiddleware");
const { loadUser } = require("../controllers/generalController");

router.route("/").get(verifyToken, loadUser, getUserNotifications);

router
  .route("/preferences")
  .put(verifyToken, loadUser, updateNotificationPreferences);

router
  .route("/subscribe")
  .post(verifyToken, loadUser, registerPushSubscription);

router
  .route("/remove-subscribe")
  .post(verifyToken, loadUser, removePushSubscription);

module.exports = router;
