const router = require("express").Router();
const { loadUser } = require("../controllers/generalController");
const {
  assignUserPermissions,
  getUserPermissions,
} = require("../controllers/permissionController");

const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/permissions/assign")
  .put(verifyToken, loadUser, assignUserPermissions);
router
  .route("/permissions/:userId")
  .get(verifyToken, loadUser, getUserPermissions);

module.exports = router;
