const router = require("express").Router();
const { loadUser } = require("../controllers/generalController");
const {
  createProduct,
  getAllProducts,
  getSingleProduct,
  updateProduct,
  removeProduct,
  getProductsOutOfStock,
  getProductsInstock,
  getProductAboutToOutofStock,
  getExpiredProduct,
  updateProductQuantity,
  exportProductData,
  makeProductInActive,
  getSingleProductsByCategory,
  getProductsAboutToExpire,
  getAllProductsToSell,
  makeProductInActiveUnActive,
  activeMultipleProduct,
  activeHideExpireDate,
  updateProductCostPrice,
  getSingleProductByID,
  updateProductSellingPrice,
} = require("../controllers/productsController");
const {
  getAllProductsForMobile,
} = require("../controllers/productsMobileController");
const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/products")
  .post(verifyToken, loadUser, createProduct)
  .get(verifyToken, loadUser, getAllProducts);

router.route("/products/sale").get(verifyToken, loadUser, getAllProductsToSell);
router
  .route("/product/:slug")
  .get(verifyToken, loadUser, getSingleProduct)
  .put(verifyToken, loadUser, updateProduct);

router
  .route("/product/singleById/:productId")
  .get(verifyToken, loadUser, getSingleProductByID);

router
  .route("/product/cost_price/:slug")
  .post(verifyToken, loadUser, updateProductCostPrice);
router
  .route("/product/selling_price/:id")
  .put(verifyToken, loadUser, updateProductSellingPrice);

router.route("/product/:id").delete(verifyToken, loadUser, removeProduct);

router
  .route("/products/instock")
  .get(verifyToken, loadUser, getProductsInstock);

router
  .route("/products/productsoutofstock")
  .get(verifyToken, loadUser, getProductsOutOfStock);
router
  .route("/products/productsabouttogooutofstock")
  .get(verifyToken, loadUser, getProductAboutToOutofStock);
router.route("/products/expired").get(verifyToken, loadUser, getExpiredProduct);
router
  .route("/products/productsabouttoexpired")
  .get(verifyToken, loadUser, getProductsAboutToExpire);
router
  .route("/product/quantity/:slug")
  .put(verifyToken, loadUser, updateProductQuantity);

router.route("/products/export").get(verifyToken, loadUser, exportProductData);
router
  .route("/product/makeproduct-inactive-unactive/:id")
  .post(verifyToken, loadUser, makeProductInActiveUnActive);

router
  .route("/product/active-multiple-products")
  .post(verifyToken, loadUser, activeMultipleProduct);
router
  .route("/product/hide-expire/date-products")
  .post(verifyToken, loadUser, activeHideExpireDate);
router
  .route("/product/inactive/:slug")
  .put(verifyToken, loadUser, makeProductInActive);
router
  .route("/product/category/:id")
  .get(verifyToken, loadUser, getSingleProductsByCategory);

router
  .route("/products/mobile")
  .get(verifyToken, loadUser, getAllProductsForMobile);

module.exports = router;
