const router = require("express").Router();
const { loadUser } = require("../controllers/generalController");
const {
  createProductsPurchase,
  getAllPurchase,
  getProductsPurchaseByDate,
  getPurchaseProductsLimit,
  updatePurchase,
  getAllProductsWithReasons,
  createPurchaseOrder,
  getPurchaseOrderByDate,
  updatePurchaseOrder,
  deleteProductInPurchase,
  getPurchasesReturnsDataByDate,
  updatePurchaseDate,
  updatePurchaseProductQty,
  updatePurchaseProductDate,
  getUnpaidPurchasesForSupplier,
  getTotalBalanceForSupplier,
  repaySupplierBalance,
  getPurchasePaymentHistory,
  updateSupplierBalance,
} = require("../controllers/purchaseController");

const { verifyToken } = require("../middlewares/authMiddleware");

router
  .route("/purchase")
  .post(verifyToken, loadUser, createProductsPurchase)
  .get(verifyToken, loadUser, getAllPurchase);
router
  .route("/purchase/purchase-order")
  .post(verifyToken, loadUser, createPurchaseOrder);

router
  .route("/purchase/limit")
  .get(verifyToken, loadUser, getPurchaseProductsLimit);
router
  .route("/purchase/:purchaseId/products/:productId")
  .delete(verifyToken, loadUser, deleteProductInPurchase);
router
  .route("/purchase/bydate")
  .get(verifyToken, loadUser, getProductsPurchaseByDate);
router
  .route("/purchase/orders/bydate")
  .get(verifyToken, loadUser, getPurchaseOrderByDate);

router
  .route("/purchase/updateqty/:slug")
  .put(verifyToken, loadUser, updatePurchase);
router
  .route("/update-date/purchase/invoice/:id")
  .put(verifyToken, loadUser, updatePurchaseDate);
router
  .route("/purchase/update/product-quatity")
  .post(verifyToken, loadUser, updatePurchaseProductQty);
router
  .route("/purchase/update/product-date")
  .post(verifyToken, loadUser, updatePurchaseProductDate);

router
  .route("/purchase/order/updateqty")
  .post(verifyToken, loadUser, updatePurchaseOrder);
router
  .route("/purchase/purchases/returns")
  .get(verifyToken, loadUser, getAllProductsWithReasons);
router
  .route("/purchase/returns/:productId")
  .get(verifyToken, loadUser, getPurchasesReturnsDataByDate);
router
  .route("/unpaid/supplier/:supplierId")
  .get(verifyToken, loadUser, getUnpaidPurchasesForSupplier);
router
  .route("/supplier-balance/:supplierId")
  .get(verifyToken, loadUser, getTotalBalanceForSupplier);
router
  .route("/supplier-balance/repay")
  .post(verifyToken, loadUser, repaySupplierBalance);
router.route("/update/repay").put(verifyToken, loadUser, updateSupplierBalance);
router
  .route("/payment/history/:purchaseId")
  .get(verifyToken, loadUser, getPurchasePaymentHistory);

module.exports = router;
