const router = require("express").Router();
const { loadUser } = require("../controllers/generalController");
const {
  permanentlyDeleteDocuments,
  restoreDocument,
  deleteDocument,
  getAllRecycleBinDocuments,
} = require("../controllers/recycleBinController");
const { verifyToken } = require("../middlewares/authMiddleware");

router.route("/document/:id").post(verifyToken, loadUser, deleteDocument);
router
  .route("/recycle-bin/documents")
  .get(verifyToken, loadUser, getAllRecycleBinDocuments);
router
  .route("/recycle-bin/permanent-delete")
  .post(verifyToken, loadUser, permanentlyDeleteDocuments);
router
  .route("/recycle-bin/restore/:id")
  .post(verifyToken, loadUser, restoreDocument);

module.exports = router;
