const router = require("express").Router();
const { loadUser } = require("../controllers/generalController");
const {
  createReport,
  getAllReports,
  deleteReport,
  getStockValueReport,
  getStockVarianceReport,
  getStockVarianceIndividualReport,
  calculateProfitAndSubProfit,
  getDailySales,
  getGrandTotalsForYear,
  getExpensesStatistics,
  getMonthlySalesByDateRange,
  getOutstandingDebtors,
  calculateProfitAndSubProfitForPeriod,
} = require("../controllers/reportsController");
const { verifyToken } = require("../middlewares/authMiddleware");

// Base reports
router
  .route("/reports")
  .post(verifyToken, loadUser, createReport)
  .get(verifyToken, loadUser, getAllReports);

router.route("/report/delete/:id").delete(verifyToken, loadUser, deleteReport); // More RESTful

// Specialized reports
router
  .route("/reports/stock-value")
  .get(verifyToken, loadUser, getStockValueReport);

router
  .route("/reports/stock-variance")
  .get(verifyToken, loadUser, getStockVarianceReport);

router
  .route("/reports/stock-variance/individual")
  .get(verifyToken, loadUser, getStockVarianceIndividualReport);

router.route("/reports/daily-sales").get(verifyToken, loadUser, getDailySales);

router
  .route("/sales/daily")
  .get(verifyToken, loadUser, getMonthlySalesByDateRange);

router
  .route("/reports/profit-summary")
  .get(verifyToken, loadUser, calculateProfitAndSubProfit);

router
  .route("/reports/grand-totals")
  .get(verifyToken, loadUser, getGrandTotalsForYear);

router
  .route("/reports/expenses-stats")
  .get(verifyToken, loadUser, getExpensesStatistics);
router
  .route("/debtors/outstanding")
  .get(verifyToken, loadUser, getOutstandingDebtors);
router
  .route("/profit/calculateProfitAndSubProfitForPeriod")
  .get(verifyToken, loadUser, calculateProfitAndSubProfitForPeriod);

module.exports = router;
