const express = require("express");
const salaryController = require("../controllers/salaryController");
const { loadUser } = require("../controllers/generalController");
const { verifyToken } = require("../middlewares/authMiddleware");
const router = express.Router();

router
  .route("/salaries")
  .get(verifyToken, loadUser, salaryController.getAllSalaries)
  .post(verifyToken, loadUser, salaryController.createSalary);

router
  .route("/salary/:id")
  .get(salaryController.getSalary)
  .patch(salaryController.updateSalary)
  .delete(salaryController.deleteSalary);

router.route("/salaries/search").get(salaryController.searchSalaries);

router.route("/salaries/stats").get(salaryController.getSalaryStats);
router
  .route("/salaries/employee/:employeeId")
  .get(salaryController.getEmployeeSalaries);

module.exports = router;
